local SlimUI = ThemePrefs.Get("GameplayMinimalUI")
local t = Def.ActorFrame {};

if GAMESTATE:GetPlayMode() ~= 'PlayMode_Rave' then

t[#t+1] = Def.ActorFrame {
	InitCommand=function(self) self:xy(_screen.cx,SCREEN_TOP-35) end;
	OnCommand=function(self) self:sleep(0.4):decelerate(0.3):addy(73) end;
	OffCommand=function(self) self:sleep(1) end;
	
	LoadActor("_frame") .. {
		OnCommand=function(self) self:zoom(0.85) end;
	};
	LoadFont("Common normal") .. {
		InitCommand=cmd(horizalign,center);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTraiP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTraiP2ChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local curScreen = Var "LoadingScreen";
			local curStageIndex = GAMESTATE:GetCurrentStageIndex() + 1;
			local playMode = GAMESTATE:GetPlayMode();
			local curStage = GAMESTATE:GetCurrentStage();
			if GAMESTATE:IsCourseMode() then
				local stats = STATSMAN:GetCurStageStats()
				if not stats then
					return
				end
				local mpStats = stats:GetPlayerStageStats( GAMESTATE:GetMasterPlayerNumber() )
				local songsPlayed = mpStats:GetSongsPassed() + 1
				self:settextf("%i / %i", songsPlayed, GAMESTATE:GetCurrentCourse():GetEstimatedNumStages());
			elseif curScreen == "ScreenDemonstration" then
				self:settextf("DEMO");
			else
				if GAMESTATE:IsEventMode() then
					self:settextf("FREE");
				else
					if GAMESTATE:IsExtraStage() then
						self:settextf("EXTRA");
					elseif GAMESTATE:IsExtraStage2() then
						self:settextf("ANOTHER");
					else
						self:settextf("%s", ToEnumShortString(string.upper(curStage)));
					end
				end
			end;
			self:zoom(0.75);
			self:diffuse(StageToColor(curStage));
			self:strokecolor(ColorDarkTone(StageToColor(curStage)));
		end;
	};
};
t[#t+1] = Def.ActorFrame { -- Difficulty rating P1
	InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1) and SlimUI == false);
	LoadFont("_coaster") .. { 
          InitCommand=cmd(x,Center1Player() and SCREEN_CENTER_X+65 or THEME:GetMetric(Var "LoadingScreen","PlayerP1MiscX")+100;y,SCREEN_TOP-40;draworder,101;horizalign,right);
		  OnCommand=cmd(playcommand,"Set";sleep,0.4;zoom,0.75;decelerate,0.3;y,SCREEN_TOP+40);
          CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set"); 
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3);
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
		  OffCommand=cmd(sleep,1.0);
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					local st = stepsP1:GetStepsType();
					local diff = stepsP1:GetDifficulty();
					local cd = GetCustomDifficulty(st, diff);
					self:settext(stepsP1:GetMeter())
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
					self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end	
	};

	LoadFont("_coaster") .. { -- Difficulty name P1
          InitCommand=cmd(x,Center1Player() and SCREEN_CENTER_X-76 or THEME:GetMetric(Var "LoadingScreen","PlayerP1MiscX")-100;y,SCREEN_TOP-40;draworder,101;horizalign,left;);
		  OnCommand=cmd(playcommand,"Set";sleep,0.4;zoom,0.75;decelerate,0.3;y,SCREEN_TOP+40);
          CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";); 
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  OffCommand=cmd(sleep,1.0);
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self)
			local stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					local st = stepsP1:GetStepsType();
					local diff = stepsP1:GetDifficulty();
					local cd = GetCustomDifficulty(st, diff);
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)));
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
					self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
	};
};
	
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2) and SlimUI == false);
	LoadFont("_coaster") .. { -- Difficulty rating P2
          InitCommand=cmd(x,Center1Player() and SCREEN_CENTER_X+65 or THEME:GetMetric(Var "LoadingScreen","PlayerP2MiscX")+100;y,SCREEN_TOP-40;draworder,101;horizalign,right;);
		  OnCommand=cmd(playcommand,"Set";sleep,0.4;zoom,0.75;decelerate,0.3;y,SCREEN_TOP+40;sleep,3;);
          CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";); 
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
		  OffCommand=cmd(sleep,1);
          SetCommand=function(self)
			local stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP2 ~= nil then
					local st = stepsP2:GetStepsType();
					local diff = stepsP2:GetDifficulty();
					local cd = GetCustomDifficulty(st, diff);
					self:settext(stepsP2:GetMeter())
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
					self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end	
	};

	LoadFont("_coaster") .. { -- Difficulty name P2
          InitCommand=cmd(x,Center1Player() and SCREEN_CENTER_X-76 or THEME:GetMetric(Var "LoadingScreen","PlayerP2MiscX")-100;y,SCREEN_TOP-40;draworder,101;horizalign,left;);
		  OnCommand=cmd(playcommand,"Set";sleep,0.4;zoom,0.75;decelerate,0.3;y,SCREEN_TOP+40;sleep,3;);
          CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";); 
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  OffCommand=cmd(sleep,2);
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self)
			stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP2 ~= nil then
					local st = stepsP2:GetStepsType();
					local diff = stepsP2:GetDifficulty();
					local cd = GetCustomDifficulty(st, diff);
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)));
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
					self:strokecolor(ColorDarkTone(CustomDifficultyToColor(cd)));
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
	};
};

if not GAMESTATE:IsCourseMode() then
	local dsong = GAMESTATE:GetCurrentSong();
	local dsname = dsong:GetDisplayMainTitle();
	local dssname = dsong:GetDisplaySubTitle();
	local dsartist = dsong:GetDisplayArtist();
	t[#t+1] = Def.ActorFrame {
		OnCommand=function(self) self:diffusealpha(0):sleep(1):linear(0.5):diffusealpha(1) end;
		LoadFont("Common normal")..{
			InitCommand=function(self) self:xy(_screen.cx-215,_screen.cy-225):zoom(0.8):maxwidth(400):horizalign(center) end;
			OnCommand=function(self) self:settext(dsname.." "..dssname) end;
		};
		LoadFont("Common normal")..{
			InitCommand=function(self) self:xy(_screen.cx+215,_screen.cy-225):zoom(0.8):maxwidth(400):horizalign(center) end;
			OnCommand=function(self) self:settext(dsartist) end;
		};
	};
else
	local dcourse = GAMESTATE:GetCurrentCourse();
	local dcname = dcourse:GetDisplayFullTitle();
	local dcmaker = dcourse:GetScripter();
	t[#t+1] = Def.ActorFrame {
		OnCommand=function(self) self:diffusealpha(0):sleep(1):linear(0.5):diffusealpha(1) end;
		LoadFont("Common normal")..{
			InitCommand=function(self) self:xy(_screen.cx-215,_screen.cy-225):zoom(0.8):maxwidth(400):horizalign(center) end;
			OnCommand=function(self) self:settext(dcname) end;
		};
		LoadFont("Common normal")..{
			InitCommand=function(self) self:xy(_screen.cx+215,_screen.cy-225):zoom(0.8):maxwidth(400):horizalign(center) end;
			OnCommand=function(self) self:settext(dcmaker) end;
		};
	};
end


else
	
	t[#t+1] = LoadActor("_battledisplay");

end;
	
return t
